//------------------------------------------------------------------
// FLabs frekvenciamr 0.1										   
// 16x2 LCD-vel, httrvilgts ki/bekapcsols
// kt bemenettel, 1 msodperces idalappal
// 1 Hz - 50 MHz / 10 MHz-1 GHz
//------------------------------------------------------------------
#include <avr/io.h>
#include <util/delay.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include "simple_driver.h"		//gtk rutinja kis mdostssal
#include <stdlib.h>
#include <avr/iom8.h>

#define Light_OFF()   	PORTD |=  (1<<PD0)
#define Light_ON()   	PORTD &= ~(1<<PD0)
#define Select1()   	PORTD |=  (1<<PD5); PORTB &= ~(1<<PB0);
#define Select2()   	PORTD &= ~(1<<PD5); PORTB |=  (1<<PB0);

 uint8_t  	Button1=0, Button2=0;
 char		konv[13];
 char*	 	strp;
 uint8_t 	input_select=2,input_select_elozo;
 uint32_t 	frekvencia,frekvencia_elozo,battery_voltage;
 volatile uint8_t	counter,idozites;
 uint8_t  frekvencia_T0,frekvencia_counter;
 uint16_t frekvencia_HC4020;
 //------------------------------------------------------------------
  void ADC_init(void)
  {
   ADMUX = 0x00;
   ADMUX  |= (1<<MUX1)		//ADC7 bemenet
   		  |  (1<<MUX2)
		  |  (1<<REFS1)
		  |  (1<<REFS0);	//a bels 2,56V a referencia	
   ADCSRA =  (1<<ADEN)		//AD engedlyezve
          |  (1<<ADPS2)		//ADC prescaler /128
          |  (1<<ADPS1)
          |  (1<<ADPS0);
  }
 //------------------------------------------------------------------
 uint16_t ADConvert(void) 
 {
   ADCSRA |= (1<<ADSC);			//ADC start
   while(ADCSRA & (1<<ADSC));	//ha ksz, ADSC trldik
   return (ADCL | (ADCH<<8));;
}
 //------------------------------------------------------------------
 void timer2_init(void)
 {
 		TCCR2 |= (1<<CS22)  //Timer2 bels jel szmllsa 1024-gyel osztja
              |  (1<<CS21)	//tlcsorduls kb.1/15 msodpercenknt
		      |  (1<<CS20);

		TIMSK |= (1<<TOIE2);  //interrupt engedlyezse 
 }
//-------------------------------------------------------------------
void counter_init(void) 
{
 	TCCR0 |=  (1<<CS02)  //Timer0 kls jel szmllsa lefut lre
           |  (1<<CS01);
      //   |  (1<<CS00);
 	
    TIMSK  |= (1<<TOIE0) ;  //enable interrupt
    sei();
}
//--------------------------------------------------------------------
uint8_t int2str(uint32_t szam, char* szoveg) //int tpust konvertl sztringg a kirshoz
{
 char*  ptr = szoveg;
 char	tmp;
 uint8_t  hossz,i;
 for (i=0;i<11;i++)		//a sztringet "kinullzzuk", fix 10 karakteres kijelzs
	{					// hogy a helyirtkek ne ugrljanak
    *(szoveg+i)=' ';  
  	}
	
    do {							// talaktjuk a szmot,
        *(ptr) ='0'+(szam%10);		// de felcserldik a szmjegyek sorrendje
		ptr++;
    	} while ((szam/=10));		//a legnagyobb rtkes szmjegy eltti 
									// nullk helyett szkzk szerepelnek
 hossz=(uint8_t)(ptr-szoveg);				//ennyi jegy a szm
 ptr--;
 for (uint8_t i=0;i<5;i++) 			//megfordtjuk a szmjegyek sorrendjt
 	{
    tmp=*(szoveg+i);*(szoveg+i)=*(szoveg+9-i);*(szoveg+9-i)=tmp;  
 	}
 /*  for (i=0;i<hossz/2;i++) 
 	{
    tmp=*(szoveg+i);*(szoveg+i)=*(ptr-i);*(ptr-i)=tmp;  
 	}
 */
return hossz;				//ennyi szmjegy a szm
}
//--------------------------------------------------------------------
uint16_t frekvencia_4020(void)			//a kls szmll kiolvassa
{
 uint16_t szamlalo=0;
 uint8_t  CP=0;
 uint16_t j;

 TCCR1B&=~((1<<CS11)|(1<<CS10));			//PWM lell, nehogy a kiolvasssal 
 if (PIND&(1<<PD4)) CP=1;			//		beleszaladjunk a kvetkez szmllsi ciklusba
 PORTD|=(1<<PD7); DDRD|=(1<<PD7); 	//PD7 kimenet s PD7=1-> Kiolvass indul
 if (CP==1)									//ha PD4=1, vagyis a szmll>8192
 	{
 	for(j=16384;j>8191;j--)				
 		{
 		PORTD|= (1<<PD7);		//PD7=1
 		PORTD&=~(1<<PD7);		//PD7=0
		PORTD|= (1<<PD7);		//PD7=1
		if ((~PIND)&(1<<PD4)) {szamlalo=j; j=1;}	//ha PD4=0 lett, megkaptuk a HC4020-ban 
 		}											//trolt szmot
	}
 else										//ha PD4=0, vagyis a szmll<8192
 	{
 	for(j=8191;j>0;j--)			
 		{
 		PORTD|= (1<<PD7);		//PD7=1
 		PORTD&=~(1<<PD7);		//PD7=0
		PORTD|= (1<<PD7);		//PD7=1
		if (PIND&(1<<PD4)) {szamlalo=j; j=1;}		//ha PD4=1 lett, megkaptuk...
 		}
 	}

DDRD  &= ~(1<<PD7);PORTD &=~(1<<PD7); //PD7 bemenet s felhz kikapcsolva:kiolvass befejezdtt
PORTD |=  (1<<PD6);						//Reset=1
PORTD &= ~(1<<PD6);
TCCR1B|=(1<<CS11)|(1<<CS10);			//PWM tovbb indul
return szamlalo;
}
//--------------------------------------------------------------------
void test(uint8_t adat)	//ez csak egy bjtot jelent meg bitenknt a kijelzn, a fejleszts sorn hasznltam
{
 lcd_set_DDRAM_addr(0);
 if(adat&0b10000000) lcd_putch ('1'); else lcd_putch('0');
 if(adat&0b01000000) lcd_putch ('1'); else lcd_putch('0');
 if(adat&0b00100000) lcd_putch ('1'); else lcd_putch('0');
 if(adat&0b00010000) lcd_putch ('1'); else lcd_putch('0');
 if(adat&0b00001000) lcd_putch ('1'); else lcd_putch('0');
 if(adat&0b00000100) lcd_putch ('1'); else lcd_putch('0');
 if(adat&0b00000010) lcd_putch ('1'); else lcd_putch('0');
 if(adat&0b00000001) lcd_putch ('1'); else lcd_putch('0');
}
//--------------------------------------------------------------------
void button(void)	//T2 megszaktsa hvja meg 1/15 msodpercenknt, a 2 nyomgombot krdezi le
{
Button1=Button1<<1;	//az elzmnyek shiftelse
Button2=Button2<<1;
if (~PIND &(1<<PD1)) Button1|=0b00000001; else Button1&=0b11111110;	//Button1=1 ha meg van nyomva
if (~PIND &(1<<PD2)) Button2|=0b00000001; else Button2&=0b11111110; //Button2=1 ha meg van nyomva

if ((Button2&0b00000111)==1)		//httrvilgits ki-/bekapcsolsa pergsmentesitssel
  	{
 	if (~PORTD&(1<<PD0)) Light_OFF(); else Light_ON();
  	}
if ((Button1&0b00000111)==1)		//Select1-2 kapcsolsa
  	{
 	if (input_select==1) input_select=2;
	else                 input_select=1;
  	}
}
//--------------------------------------------------------------------
void PWM_init()				//Timer1 belltsa a kapujel generlsra
{							//jelenleg csak az 1 msodperces kapuid mkdik

  //TCCR1A |= (1<<WGM10);     
  TCCR1A |= (1<<WGM11);		//fast mode PWM (datasheet 14. mode)
  TCCR1B |= (1<<WGM12);     
  TCCR1B |= (1<<WGM13);
  TCCR1B |= (1<<CS11);		//presc: 64; F_CPU = 4 000 000Hz;
  TCCR1B |= (1<<CS10);
  //TCCR1A |= (1<<COM1A0);	// invertalt PWM, A csatorna
  TCCR1A |= (1<<COM1A1);    // fast PWM
  DDRB   |= (1<<PB1);     	// PORTB PB1 lab kimenet
  OCR1A = 62499;         	// PWM kitoltesi tenyezo:4MHz/64/62500 = 1s
  ICR1  = 65500;			// TOP ertek megadasa: nem kritikus az rtke, csak 
  							// ne legyen tl kzel az elbbihez.
}							//ha ez a szm is letelt, akkor indul jra az 1s kapuid

//------------------------------------------------------------------
SIGNAL(SIG_OVERFLOW0)		//Timer0 tlcsordulsa ltal kivltott megszakts
{
   counter++;				//a HC4020 Q14-as jel szmllsa		
}
 //------------------------------------------------------------------
SIGNAL(SIG_OVERFLOW2)		//Timer2 tlcsordulsa ltal kivltott megszakts
{
   button();idozites++;		// kb. 1/15 msodpercenknt meghvdik a nyomgombok lekrdezshez
}
//-------------------------------------------------------------------
void kijelzes(void)	//ha valami vltozott a kijelzend rtkek kzl (pl. frekvencia nan!)
{					//akkor ez a fv. rja ki a HD44780 komp. kijelzre
 
if (input_select!=input_select_elozo)		//a bemenetvlaszts kijelzse
 	{
	PORTD |=  (1<<PD6);						//Reset=1
	PORTD &= ~(1<<PD6);
	frekvencia_counter=0;counter=0;
	frekvencia_T0=0;TCNT0=0;	//a szmllk trlse, hogy 											
	frekvencia_HC4020=0;		//a bemenet vltozsakor hlye rtkek ne jelenjenek meg
	if (input_select==2) 
		{Select2();input_select_elozo=input_select;lcd_putstr("2",0xF);}
	if (input_select==1) 
		{Select1();input_select_elozo=input_select;lcd_putstr("1",0xF);}
	}
 frekvencia=(uint32_t)frekvencia_counter<<22;
 frekvencia+=(uint32_t)frekvencia_T0<<14;
 frekvencia+=frekvencia_HC4020;

if (input_select==1) 
		{
		if ((frekvencia_counter==0) && (frekvencia_T0<9)) 
										frekvencia=0;//a Be1 10MHz-es  min. bemen frekije miatt
		}		//az ez alattiakat trljk, azrt, hogy ne ugrljon a szmll, 
				//ha nincs rajta korrekt bemeneti jel
 if (frekvencia!=frekvencia_elozo) 			//frekvencia kijelzse
 	{
 	if (input_select==1) frekvencia<<=6;		//a 64-es eloszt miatt
	int2str(frekvencia,strp);
	konv[10]=konv[9];konv[9]=konv[8];konv[8]=konv[7];konv[7]=' ';
	if (frekvencia>999) {konv[7]=',';lcd_putstr ("k",0x4D);}	//tizedesvessz kirsa	
		else {lcd_putstr (" ",0x4D);}							//Hz kirsa, vagyis letrljk a "k"-t a "kHz"-bl
 	lcd_putstr(strp,0x41);
	frekvencia_elozo=frekvencia;
  	}
 if (idozites<3) lcd_putstr ("G",0x0); else lcd_putstr (" ",0x0);		//A Gate jelzs kirsa, 1 msodpercenknt felvillan

 if (battery_voltage<220)
 	{
 	if ((battery_voltage>210)&&(idozites<4)) lcd_putstr ("Low battery",2); //"Low battery" villog 2,2V alatt
 		else lcd_putstr ("Frekvencia ",2);
	if (battery_voltage<210) lcd_putstr ("Low battery  ",0x0);	//"Low battery" lland 2,1V alatt
	}		 
}
//-------------------------------------------------------------------
int main ()
{
  DDRD = 0b01100001;		//PD0,PD5,PD6: kimenet, a tobbi bemenet
  PORTD= 0b00001111;		//felhuzo-ellenallasok bekapcsolasa, kivve PD4 es PD7
  DDRB = 0b00000001;		//PB0:kimenet, a tbbi bemenet
  PORTB= 0xff;				//felhuzo-ellenallasok bekapcsolasa
  strp = &konv[0];

  if (input_select==2) {Select2();} else {Select1();}	//bemenet kivlasztsa, indulskor Be2 aktv
  input_select_elozo=input_select;
  
  lcd_init ();
  /*display on, cursor & blink off */
  lcd_control (1, 0, 0);
  lcd_cls ();
  frekvencia=0;frekvencia_elozo=1;
  Light_ON();			//httrvilgts be
  lcd_putstr ("FLabs       0.1",0x40); lcd_putstr ("Frekvenciamero",0);
  _delay_ms(2000);lcd_cls ();

  lcd_putstr ("Frekvencia",2);

  if (input_select==1)  {lcd_putstr ("Be1",0x0D);} 
  else {lcd_putstr ("Be2",0x0D);}
  lcd_putstr (" Hz",0x4D);
  

  timer2_init();					//timerek indtsa
  PWM_init();						//a kapujel ellltshoz
  counter_init();					// a bels 8 bites (T0) szmll belltsa
  ADC_init();						//az AD csak az elem lemerlsnek jelzshez kell,
									//hogy ne vigye mlykistsbe az akkukat


  while(1)							//itt indul a vgtelen ciklus mrssel, kijelzssel, mindennel
  	{
  	while(!(TIFR&(1<<OCF1A))) {kijelzes();}		//vr a kapujel felfutsra, a szmlls befejezdtt, jhet		
  	idozites=0;									// a kirtkels
  	TIFR|=(1<<OCF1A);							//trljk a PWM flag-et, hogy ez az g minden kapuzsnl csak egyszer fusson le
	frekvencia_T0=TCNT0; frekvencia_counter=counter;		//szmllk kiolvassa
	frekvencia_HC4020=frekvencia_4020();

	TCNT0=0;										//s nullzsa
	counter=0;
	battery_voltage=((uint32_t)ADConvert()*267)>>10;	//2,67V a bels referencia feszltsg a
   	}													//mrsem szerint (adatlapban 2,56V) mdostand msik kontroller pldnynl
  return 0;
}
